/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.generationaleatoire;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class GenerationSeed {
    private static Logger log = Logger.getLogger(GenerationSeed.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, char[] cArray) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                if (cArray != null) {
                    ResultatInfo resultatInfo = new ResultatInfo("G\u00e9n\u00e9ration coupl\u00e9e \u00e0 une graine (seed) d'un nombre pseudo-al\u00e9atoire (C_SeedRandom)");
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                    resultatInfo.setInfos(linkedHashMap);
                    try {
                        byte[] byArray = new String(cArray).getBytes();
                        pKCS11.C_SeedRandom(l, byArray);
                        if (byArray == null) {
                            log.error((Object)"L'operation a retourne un nombre aleatoire nul");
                            throw new ExceptionTraitement(33, "L'op\u00e9ration a retourn\u00e9 un nombre al\u00e9atoire nul");
                        }
                        linkedHashMap.put("Nombre aleatoire g\u00e9n\u00e9r\u00e9", TraitementsUtil.getHexadecimal(byArray, null));
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                    }
                    return resultatInfo;
                }
                log.error((Object)"Le seed est nul");
                throw new ExceptionTraitement(33, "La graine (seed) est nulle");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(33, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(33, "Une erreur inattendue est survenue");
        }
    }
}

